package com.biz.crm.dms.promotion;

import com.biz.crm.common.PageResult;
import com.biz.crm.dms.promotion.impl.PromotionRuleFeignImpl;
import com.biz.crm.nebular.dms.promotion.*;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.List;


/**
 * 促销规则
 *  @author: luoqi
 *  @Date: 2020-10-19 18:16
 *  @version: V1.0
 *  @Description:
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "promotionRuleFeign",name="crm-dms",path = "dms",fallbackFactory = PromotionRuleFeignImpl.class)
public interface PromotionRuleFeign {



    @PostMapping("/promotion/rule")
    Result addOrUpdate( PromotionRuleEditVo vo) ;


    /**
     * 测试脚本体
     *  @author: luoqi
     *  @Date: 2020-10-19 18:40
     *  @version: V1.0
     *  @Description:
     */
    @PostMapping("/promotion/rule/testfunc")
    Result<Object> testFunc(PromotionRuleEditVo vo);

    @GetMapping("/promotion/rule/editinfo")
    Result<PromotionRuleVo> loadEditVoById(@RequestParam("id") String id);

    @DeleteMapping("/promotion/rule/del")
    Result del(@RequestParam("id") String id) ;

}
