package com.biz.crm.dms.promotion.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.dms.promotion.PromotionPolicyFeign;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyConfigInfoQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyEditVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyInfoVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyQueryVo;
import com.biz.crm.nebular.dms.promotion.PromotionPolicyVo;
import com.biz.crm.nebular.dms.promotion.policy.req.DmsPromotionPolicyOrderDetailReqVo;
import com.biz.crm.nebular.dms.promotion.policy.resp.PromotionPolicyInfoDataVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Map;


/**
 * 促销政策
 *  @author: luoqi
 *  @Date: 2020-10-19 18:15
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class PromotionPolicyFeignImpl extends BaseAbstract implements FallbackFactory<PromotionPolicyFeign> {
    @Override
    public PromotionPolicyFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new PromotionPolicyFeign() {


            /**
             * 查询给定的客户在给定的商量下能够享受的促销政策
             *
             * @param custCode
             * @param productCode
             * @author: luoqi
             * @Date: 2020-10-21 11:20
             * @version: V1.0
             * @Description:
             */
            @Override
            public Result<List<PromotionPolicyInfoDataVo>> loadPromotionPolicyInfoByCustAndProduct(String custCode, String productCode) {
                return doBack();
            }

            /**
             * 查询给定的客户在给定的商品列表下能够享受的促销政策
             *
             * @param custCode
             * @param productCodes
             * @author: luoqi
             * @Date: 2020-10-30 14:18
             * @version: V1.0
             * @Description:
             */
            @Override
            public Result<Map<String, List<PromotionPolicyInfoVo>>> loadPromotionPolicyInfoByCustAndProducts(String custCode, List<String> productCodes) {
                return doBack();
            }

            /**
             * 给定的客户在给定的商品列表下是否能享受促销政策
             *
             * @param custCode
             * @param productCodes
             * @author: luoqi
             * @Date: 2020-10-30 14:18
             * @version: V1.0
             * @Description:
             */
            @Override
            public Result<Map<String, Boolean>> custProductsHasPromotionPolicy(String custCode, List<String> productCodes) {
                return doBack();
            }

            /**
             * 根据客户查询所有可用促销（商品编码作为key）
             * @param cusCode
             * @return
             */
            @Override
            public Result<Map<String, List<PromotionPolicyConfigInfo>>> findProductMapByCusCode(String cusCode) {
                return doBack();
            }

            /**
             * 加载订单下所有商品享受的促销政策和政策规则配置信息
             * @param configInfoQueryVo
             * @return
             */
            @Override
            public Result<Map<String, List<PromotionPolicyConfigInfo>>> loadPromotionPolicyConfigInfoForOrder(PromotionPolicyConfigInfoQueryVo configInfoQueryVo) {
                return doBack();
            }

            /**
             * 锁定促销政策使用明细
             * @param reqVo
             * @return
             */
            @Override
            public Result<Boolean> lockPromotionPolicyOrderDetail(DmsPromotionPolicyOrderDetailReqVo reqVo) {
                return doBack();
            }

            /**
             * 提交促销政策使用明细
             * @param orderNo
             * @return
             */
            @Override
            public Result<Boolean> commitPromotionPolicyOrderDetail(String orderNo) {
                return doBack();
            }

            /**
             * 释放促销政策使用明细
             * @param orderNo
             * @return
             */
            @Override
            public Result<Boolean> unlockPromotionPolicyOrderDetail(String orderNo) {
                return doBack();
            }

            /**
             * 回滚促销政策使用明细
             * @param orderNo
             * @return
             */
            @Override
            public Result<Boolean> rollbackPromotionPolicyOrderDetail(String orderNo) {
                return doBack();
            }
        };
    }
}
