package com.biz.crm.dms.promotion.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.dms.promotion.PromotionV2Feign;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionAvailableResp;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionEditVo;
import com.biz.crm.nebular.dms.npromotion.vo.PromotionQueryReq;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2021/5/12 15:28
 **/
@Slf4j
@Component
public class PromotionV2FeignImpl extends BaseAbstract implements FallbackFactory<PromotionV2Feign> {
    @Override
    public PromotionV2Feign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new PromotionV2Feign() {

            @Override
            public Result<Map<String, PromotionEditVo>> findHitPromotionMapByPromotionCodes(ArrayList<PromotionQueryReq> params) {
                return doBack();
            }

            @Override
            public Result<List<PromotionAvailableResp>> findAvailablePromotionsByAccount(PromotionQueryReq param) {
                return doBack();
            }
        };
    }
}
