package com.biz.crm.dms.salestarget;

import com.biz.crm.common.PageResult;
import com.biz.crm.dms.salestarget.impl.SalesTargetFeignImpl;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/** 销售目标
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/9/27 16:15
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "salesTargetFeign",name="crm-dms",path = "dms",fallbackFactory = SalesTargetFeignImpl.class)
public interface SalesTargetFeign {

    /**
     * 批量新增产品类型
     */
    @PostMapping(value = "/m/salesTarget/addBatch")
    Result addBatch(@RequestBody List<SalesTargetVo> salesTargetVos);

    /**
     * 编辑
     */
    @PostMapping(value = "/m/salesTarget/edit")
    Result edit(@RequestBody SalesTargetVo salesTargetVo);

    /**
     * 通过id查询
     */
    @GetMapping(value = "/m/salesTarget/findById/{id}")
    Result<SalesTargetVo> findById(@PathVariable("id") String id);

    /**
     * 分页搜索
     */
    @PostMapping(value = "/m/salesTarget/list")
    Result<PageResult<SalesTargetVo>> list(@RequestBody SalesTargetVo salesTargetVo);

    /**
     * 根据id批量删除
     */
    @PostMapping(value = "/m/salesTarget/delByIds")
    Result<Object> delByIds(@RequestBody ArrayList<String> ids);

    /**
     * 根据查询条件批量删除
     */
    @PostMapping(value = "/m/salesTarget/delByParam")
    Result<Object> delByParam(@RequestBody SalesTargetVo salesTargetVo);
}
