package com.biz.crm.dms.salestarget.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.dms.salestarget.SalesTargetFeign;
import com.biz.crm.nebular.dms.salestarget.SalesTargetVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/9/27 16:21
 **/
@Slf4j
@Component
public class SalesTargetFeignImpl extends BaseAbstract implements FallbackFactory<SalesTargetFeign> {

    @Override
    public SalesTargetFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new SalesTargetFeign() {
            @Override
            public Result addBatch(List<SalesTargetVo> salesTargetVos) {
                return doBack();
            }

            @Override
            public Result edit(SalesTargetVo salesTargetVo) {
                return doBack();
            }

            @Override
            public Result<SalesTargetVo> findById(String id) {
                return doBack();
            }

            @Override
            public Result<PageResult<SalesTargetVo>> list(SalesTargetVo salesTargetVo) {
                return doBack();
            }

            @Override
            public Result<Object> delByIds(ArrayList<String> ids) {
                return doBack();
            }

            @Override
            public Result<Object> delByParam(SalesTargetVo salesTargetVo) {
                return doBack();
            }
        };
    }
}
