package com.biz.crm.external.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.OpenIdVo;
import com.biz.crm.external.WeChatFeign;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * 用户信息表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@Slf4j
@Component
public class WeChatFeignImpl extends BaseAbstract implements FallbackFactory<WeChatFeign> {

    @Override
    public WeChatFeign create(Throwable throwable) {
        return new WeChatFeign() {

            @Override
            public Result<OpenIdVo> obtainOpenId(String code) {
                return doBack();
            }

            @Override
            public Result<Integer> generateTest() {
                return doBack();
            }
        };
    }
}
