package com.biz.crm.fee.pool;

import com.biz.crm.fee.pool.impl.FeePoolFeignImpl;
import com.biz.crm.nebular.fee.pool.req.*;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

@FeignClient(url = "${feign.urlip:}", qualifier = "feePoolFeign", name = "crm-fee", path = "fee", fallbackFactory = FeePoolFeignImpl.class)
public interface FeePoolFeign {

    /**
     * 通用上账
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/feePoolController/account")
    Result<String> account(@RequestBody FeePoolAccountReqVo reqVo);

    /**
     * 通用上账（批量）
     *
     * @param list
     * @return
     */
    @PostMapping("/feePoolController/accountBatch")
    Result<String> accountBatch(@RequestBody List<FeePoolAccountReqVo> list);

    /**
     * 回滚（慎用）
     *
     * @param rollbackCode
     * @return
     */
    @PostMapping("/feePoolController/rollback")
    Result rollback(@RequestParam(value = "rollbackCode", required = true) String rollbackCode);

    /**
     * 查询费用池可用金额/数量
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/feePoolController/queryPoolAmount")
    Result<FeePoolAmountQueryRespVo> queryPoolAmount(@RequestBody FeePoolAmountQueryReqVo reqVo);

    /**
     * 使用费用池金额/数量
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/feePoolController/usePool")
    Result usePool(@RequestBody FeePoolUseReqVo reqVo);

    /**
     * 使用费用池金额/数量（批量）
     *
     * @param list
     * @return
     */
    @PostMapping("/feePoolController/usePoolBatch")
    Result usePoolBatch(@RequestBody List<FeePoolUseReqVo> list);

    /**
     * 重新使用，先退回已使用，再按照参数重新使用
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/feePoolController/usePoolAfterBackByFromCode")
    Result usePoolAfterBackByFromCode(@RequestBody FeePoolUseReqVo reqVo);

    /**
     * 重新使用，先退回已使用，再按照参数重新使用（批量）
     *
     * @param list
     * @return
     */
    @PostMapping("/feePoolController/usePoolAfterBackByFromCodeBatch")
    Result usePoolAfterBackByFromCodeBatch(@RequestBody List<FeePoolUseReqVo> list);

    /**
     * 全量回退使用金额/数量，根据来源单号
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/feePoolController/backAllUseByFromCode")
    Result backAllUseByFromCode(@RequestBody FeePoolUseBackAllReqVo reqVo);

    /**
     * 全量回退使用金额/数量，根据来源单号（批量）
     *
     * @param list
     * @return
     */
    @PostMapping("/feePoolController/backAllUseByFromCodeBatch")
    Result backAllUseByFromCodeBatch(@RequestBody List<FeePoolUseBackAllReqVo> list);

    /**
     * 回退使用金额/数量，根据来源单号
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/feePoolController/backUseByFromCode")
    Result backUseByFromCode(@RequestBody FeePoolUseBackReqVo reqVo);

    /**
     * 回退使用金额/数量，根据来源单号（批量）
     *
     * @param list
     * @return
     */
    @PostMapping("/feePoolController/backUseByFromCodeBatch")
    Result backUseByFromCodeBatch(@RequestBody List<FeePoolUseBackReqVo> list);

    /**
     * 占用费用池金额/数量
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/feePoolController/occupyPool")
    Result occupyPool(@RequestBody FeePoolUseReqVo reqVo);

    /**
     * 占用费用池金额/数量（批量）
     *
     * @param list
     * @return
     */
    @PostMapping("/feePoolController/occupyPoolBatch")
    Result occupyPoolBatch(@RequestBody List<FeePoolUseReqVo> list);

    /**
     * 全量回退占用金额/数量，根据来源单号
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/feePoolController/backAllOccupyByFromCode")
    Result backAllOccupyByFromCode(@RequestBody FeePoolOccupyBackAllReqVo reqVo);

    /**
     * 全量回退占用金额/数量，根据来源单号（批量）
     *
     * @param list
     * @return
     */
    @PostMapping("/feePoolController/backAllOccupyByFromCodeBatch")
    Result backAllOccupyByFromCodeBatch(@RequestBody List<FeePoolOccupyBackAllReqVo> list);

    /**
     * 把占用的金额/数量变成使用，根据来源单号
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/feePoolController/occupyToUseByFromCode")
    Result occupyToUseByFromCode(@RequestBody FeePoolOccupyToUseReqVo reqVo);

    /**
     * 把占用的金额/数量变成使用，根据来源单号（批量）
     *
     * @param list
     * @return
     */
    @PostMapping("/feePoolController/occupyToUseByFromCodeBatch")
    Result occupyToUseByFromCodeBatch(@RequestBody List<FeePoolOccupyToUseReqVo> list);

}
