package com.biz.crm.fee.pool.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.fee.pool.FeePoolFeign;
import com.biz.crm.nebular.fee.pool.req.*;
import com.biz.crm.nebular.fee.pool.resp.FeePoolAmountQueryRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

@Slf4j
@Component
public class FeePoolFeignImpl extends BaseAbstract implements FallbackFactory<FeePoolFeign> {

    @Override
    public FeePoolFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new FeePoolFeign() {

            @Override
            public Result<String> account(FeePoolAccountReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<String> accountBatch(List<FeePoolAccountReqVo> list) {
                return doBack();
            }

            @Override
            public Result rollback(String rollbackCode) {
                return doBack();
            }

            @Override
            public Result<FeePoolAmountQueryRespVo> queryPoolAmount(FeePoolAmountQueryReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result usePool(FeePoolUseReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result usePoolBatch(List<FeePoolUseReqVo> list) {
                return doBack();
            }

            @Override
            public Result usePoolAfterBackByFromCode(FeePoolUseReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result usePoolAfterBackByFromCodeBatch(List<FeePoolUseReqVo> list) {
                return doBack();
            }

            @Override
            public Result backAllUseByFromCode(FeePoolUseBackAllReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result backAllUseByFromCodeBatch(List<FeePoolUseBackAllReqVo> list) {
                return doBack();
            }

            @Override
            public Result backUseByFromCode(FeePoolUseBackReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result backUseByFromCodeBatch(List<FeePoolUseBackReqVo> list) {
                return doBack();
            }

            @Override
            public Result occupyPool(FeePoolUseReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result occupyPoolBatch(List<FeePoolUseReqVo> list) {
                return doBack();
            }

            @Override
            public Result backAllOccupyByFromCode(FeePoolOccupyBackAllReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result backAllOccupyByFromCodeBatch(List<FeePoolOccupyBackAllReqVo> list) {
                return doBack();
            }

            @Override
            public Result occupyToUseByFromCode(FeePoolOccupyToUseReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result occupyToUseByFromCodeBatch(List<FeePoolOccupyToUseReqVo> list) {
                return doBack();
            }
        };
    }
}
