package com.biz.crm.job;

import com.biz.crm.common.PageResult;
import com.biz.crm.job.impl.QrtzScheduleJobFeignImpl;
import com.biz.crm.job.impl.QrtzScheduleJobLogFeignImpl;
import com.biz.crm.nebular.job.req.QrtzScheduleJobLogReqVo;
import com.biz.crm.nebular.job.resp.QrtzScheduleJobLogRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Project crm-core-prd
 * @PackageName com.biz.crm.job
 * @ClassName QrtzScheduleJobFeign
 * @Author X.S
 * @Date 2020/9/30 5:03 PM
 * @Description
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "QrtzScheduleJobLogFeign",name="crm-job",path = "job",fallbackFactory = QrtzScheduleJobLogFeignImpl.class)
public interface QrtzScheduleJobLogFeign {
    /**
     * 列表
     */
    @PostMapping("/qrtzScheduleJobLog/list")
    Result<PageResult<QrtzScheduleJobLogRespVo>> list(@RequestBody QrtzScheduleJobLogReqVo qrtzScheduleJobLogReqVo);

    /**
     * 查询
     */
    @PostMapping("/qrtzScheduleJobLog/query")
    Result<QrtzScheduleJobLogRespVo> query(@RequestBody QrtzScheduleJobLogReqVo qrtzScheduleJobLogReqVo);

    /**
     * 新增
     */
    @PostMapping("/qrtzScheduleJobLog/save")
    Result save(@RequestBody QrtzScheduleJobLogReqVo qrtzScheduleJobLogReqVo);

}
