package com.biz.crm.job.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.job.QrtzScheduleJobFeign;
import com.biz.crm.job.QrtzScheduleJobLogFeign;
import com.biz.crm.nebular.job.req.QrtzScheduleJobLogReqVo;
import com.biz.crm.nebular.job.req.QrtzScheduleJobReqVo;
import com.biz.crm.nebular.job.resp.QrtzScheduleJobLogRespVo;
import com.biz.crm.nebular.job.resp.QrtzScheduleJobRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * @Project crm-core-prd
 * @PackageName com.biz.crm.job.impl
 * @ClassName QrtzScheduleJobFeignImpl
 * @Author X.S
 * @Date 2020/9/30 5:04 PM
 * @Description
 */
@Slf4j
@Component
public class QrtzScheduleJobLogFeignImpl extends BaseAbstract implements FallbackFactory<QrtzScheduleJobLogFeign> {

    @Override
    public QrtzScheduleJobLogFeign create(Throwable throwable) {
        return new QrtzScheduleJobLogFeign() {
            @Override
            public Result<PageResult<QrtzScheduleJobLogRespVo>> list(QrtzScheduleJobLogReqVo qrtzScheduleJobLogReqVo) {
                doBack();
                PageResult<QrtzScheduleJobLogRespVo> build = PageResult.<QrtzScheduleJobLogRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            @Override
            public Result<QrtzScheduleJobLogRespVo> query(QrtzScheduleJobLogReqVo qrtzScheduleJobLogReqVo) {
                return doBack();
            }

            @Override
            public Result save(QrtzScheduleJobLogReqVo qrtzScheduleJobLogReqVo) {
                return doBack();
            }
        };

    }
}
