package com.biz.crm.job.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.job.XxlJobFeign;
import com.biz.crm.nebular.job.req.XxlJobInfoReqVo;
import com.biz.crm.nebular.job.resp.XxlJobInfoRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @Project crm
 * @PackageName com.biz.crm.job.impl
 * @ClassName XxlJobFeignImpl
 * @Author Gavin
 * @Date 2021/4/20 下午2:55
 * @Description 定时任务熔断
 */
@Slf4j
@Component
public class XxlJobFeignImpl extends BaseAbstract implements FallbackFactory<XxlJobFeign> {
    @Override
    public XxlJobFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new XxlJobFeign() {
            @Override
            public Result<XxlJobInfoRespVo> add(XxlJobInfoReqVo params) {
                return doBack();
            }

            @Override
            public Result<XxlJobInfoRespVo> update(XxlJobInfoReqVo params) {
                return doBack();
            }

            @Override
            public Result remove(List<String> ids) {
                return doBack();
            }

            @Override
            public Result start(List<String> ids) {
                return doBack();
            }

            @Override
            public Result pause(List<String> ids) {
                return doBack();
            }
        };
    }
}