package com.biz.crm.mall.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mall.MallDeliveryFeign;
import com.biz.crm.mall.dto.DeliveringDto;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author zwk
 * @date 2021/9/17
 * @description TODO
 **/
@Component
@Slf4j
public class MallDeliveryFeignImpl  extends BaseAbstract implements FallbackFactory<MallDeliveryFeign> {
    @Override
    public MallDeliveryFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MallDeliveryFeign() {
            @Override
            public Result<?> deliver(DeliveringDto dto) {
                return Result.error("feign error");
            }
        };
    }
}
