package com.biz.crm.mdm.availablelist;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.availablelist.impl.TerminalAvailableListFeignImpl;
import com.biz.crm.nebular.mdm.availablelist.TerminalAvailablelistVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/13 15:33
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "terminalAvailableListFeign",name="crm-mdm",path = "mdm",fallbackFactory = TerminalAvailableListFeignImpl.class)
public interface TerminalAvailableListFeign {

    /**
     *批量刷新终端可购清单
     * @param terminalCodes
     * @return
     */
    @PostMapping(value = "/m/terminal/availableList/reFresh/terminal")
    Result<Object> reFreshTerminal(@RequestBody ArrayList<String> terminalCodes);

    /**
     * 查询终端可购清单
     * @param terminalAvailablelistVo
     * @return
     */
    @PostMapping(value = "/m/terminal/availableList/terminal/list")
    Result<PageResult<TerminalAvailablelistVo>> listTerminal(@RequestBody TerminalAvailablelistVo terminalAvailablelistVo);

    /**
     * 根据虚拟id删除终端可购清单
     * @param id
     * @return
     */
    @GetMapping(value = "/m/terminal/availableList/terminal/delById/{id}")
    Result<Object> delById(@PathVariable("id") String id);

    /**
     * 通过id查询客户可购清单
     * @param id
     * @return
     */
    @GetMapping(value = "/m/terminal/availableList/terminal/findById/{id}")
    Result<TerminalAvailablelistVo> findById(@PathVariable("id") String id);

    /**
     * 根据id批量删除终端可购清单
     * @param ids
     * @return
     */
    @PostMapping(value = "/m/terminal/availableList/terminal/delByIds")
    Result<Object> delByIds(@RequestBody List<String> ids);
}
