package com.biz.crm.mdm.availablelist;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.availablelist.impl.TerminalAvailableListFeignImpl;
import com.biz.crm.nebular.mdm.availablelist.TerminalAvailablelistVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/13 15:33
 **/
@FeignClient(url ="${feign.urlip:}",qualifier = "terminalAvailableListNewFeign",name="crm-mdm",path = "mdm",fallbackFactory = TerminalAvailableListFeignImpl.class)
public interface TerminalAvailableListNewFeign {

    /**
     * 查询终端可购清单
     * @param terminalAvailablelistVo
     * @return
     */
    @PostMapping(value = "/api/terminal/availableList/terminal/list")
    Result<PageResult<TerminalAvailablelistVo>> listTerminal(@RequestBody TerminalAvailablelistVo terminalAvailablelistVo);

}
