package com.biz.crm.mdm.availablelist.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.availablelist.TerminalAvailableListFeign;
import com.biz.crm.nebular.mdm.availablelist.TerminalAvailablelistVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/13 15:39
 **/
@Slf4j
@Component
public class TerminalAvailableListFeignImpl extends BaseAbstract implements FallbackFactory<TerminalAvailableListFeign> {
    @Override
    public TerminalAvailableListFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new TerminalAvailableListFeign() {
            @Override
            public Result<Object> reFreshTerminal(ArrayList<String> terminalCodes) {
                return doBack();
            }

            @Override
            public Result<PageResult<TerminalAvailablelistVo>> listTerminal(TerminalAvailablelistVo terminalAvailablelistVo) {
                return doBack();
            }

            @Override
            public Result<Object> delById(String id) {
                return doBack();
            }

            @Override
            public Result<TerminalAvailablelistVo> findById(String id) {
                return doBack();
            }

            @Override
            public Result<Object> delByIds(List<String> ids) {
                return doBack();
            }
        };
    }
}
