package com.biz.crm.mdm.bpmrole;

import com.biz.crm.mdm.bpmrole.impl.MdmBpmRoleRedisFeignImpl;
import com.biz.crm.mdm.org.impl.MdmOrgRedisFeignImpl;
import com.biz.crm.nebular.mdm.bpmrole.resp.MdmBpmRoleRedisRespVo;
import com.biz.crm.nebular.mdm.org.resp.MdmOrgRedisVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * @Description: 流程角色表的feign接口
 * @project：crm-core
 * @package：com.biz.crm.mdm.bpmrole.impl
 * @author：longyu
 * @create：2021/1/14 15:18
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmBpmRoleRedisFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmBpmRoleRedisFeignImpl.class)
public interface MdmBpmRoleRedisFeign {

    @PostMapping("/mdmBpmRoleRedisController/findRedisListByBpmRoleCodeList")
    Result<List<MdmBpmRoleRedisRespVo>> findRedisListByBpmRoleCodeList(@RequestBody List<String> bpmRoleCodeList);

    @PostMapping("/mdmBpmRoleRedisController/findRedisReloadList")
    Result<List<MdmBpmRoleRedisRespVo>> findRedisReloadList();
}
