package com.biz.crm.mdm.button;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.button.impl.MdmButtonFeignImpl;
import com.biz.crm.nebular.mdm.button.MdmButtonReqVo;
import com.biz.crm.nebular.mdm.button.MdmButtonRespVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.util.Result;

/**
 * 按钮表feign接口
 *
 * @author zxw
 * @date 2020-11-18 11:33:08
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmButtonFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmButtonFeignImpl.class)
public interface MdmButtonFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmbutton/list")
    Result<PageResult<MdmButtonRespVo>> list(@RequestBody MdmButtonReqVo mdmButtonReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmbutton/query")
    Result<MdmButtonRespVo> query(@RequestBody MdmButtonReqVo mdmButtonReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmbutton/save")
    Result save(@RequestBody MdmButtonReqVo mdmButtonReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmbutton/update")
    Result update(@RequestBody MdmButtonReqVo mdmButtonReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmbutton/delete")
    Result delete(@RequestBody MdmButtonReqVo mdmButtonReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmbutton/enable")
    Result enable(@RequestBody MdmButtonReqVo mdmButtonReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmbutton/disable")
    Result disable(@RequestBody  MdmButtonReqVo mdmButtonReqVo);
}
