package com.biz.crm.mdm.crmlog;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.crmlog.impl.CrmLogFeignImpl;
import com.biz.crm.nebular.log.CrmLogVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/16 11:41
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "crmLogFeign",name="crm-mdm",path = "mdm",fallbackFactory = CrmLogFeignImpl.class)
public interface CrmLogFeign {


    /**
     * 分页搜索日志(没有指定menuCode返回空集合)
     * @param crmLogVo
     * @return
     */
    @PostMapping(value = "/api/crmlog/listNonMenuCodeReEmpty")
    Result<PageResult<CrmLogVo>> listNonMenuCodeReEmpty(@RequestBody CrmLogVo crmLogVo);

    /**
     * 分页搜索日志(没有指定menuCode查询所有模块日志)
     * @param crmLogVo
     * @return
     */
    @PostMapping(value = "/api/crmlog/listNonMenuCodeReAll")
    Result<PageResult<CrmLogVo>> listNonMenuCodeReAll(@RequestBody CrmLogVo crmLogVo);
}
