package com.biz.crm.mdm.crmlog.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.crmlog.CrmLogFeign;
import com.biz.crm.nebular.log.CrmLogVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @Description:
 * @Author: heyijiang
 * @Date: 2020/10/16 13:40
 **/
@Slf4j
@Component
public class CrmLogFeignImpl extends BaseAbstract implements FallbackFactory<CrmLogFeign> {
    @Override
    public CrmLogFeign create(Throwable throwable){
        log.error("进入熔断",throwable);
        return new CrmLogFeign() {

            @Override
            public Result<PageResult<CrmLogVo>> listNonMenuCodeReEmpty(CrmLogVo crmLogVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<CrmLogVo>> listNonMenuCodeReAll(CrmLogVo crmLogVo) {
                return doBack();
            }
        };
    }
}
