package com.biz.crm.mdm.cusorg;

import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.mdm.cusorg.impl.MdmCusOrgFeignImpl;
import com.biz.crm.nebular.mdm.cusorg.CusOrgVo;
import com.biz.crm.nebular.mdm.cusorg.MdmCustomerOrgSelectRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiModelProperty;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * @Description:
 * @Author: zhangyuzhu
 * @Date: 2020/8/26 15:39
 **/
@FeignClient(url = "${feign.urlip:}", qualifier = "mdmCusOrgFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmCusOrgFeignImpl.class)
public interface MdmCusOrgFeign {

    @ApiOperation(value = "添加客户组织")
    @PostMapping("/mdmCusOrgController/add")
    Result<Object> add(@RequestBody CusOrgVo cusOrgVo);

    @ApiOperation("查询客户组织")
    @ApiImplicitParams({
            @ApiImplicitParam(name = "id", value = "id", required = false, paramType = "query"),
            @ApiImplicitParam(name = "customerOrgCode", value = "客户组织编码", required = false, paramType = "query")
    })
    @GetMapping("/mdmCusOrgController/query")
    @CrmDictMethod
    Result<CusOrgVo> query(@RequestParam(value = "id", required = false) String id,
                           @RequestParam(value = "customerOrgCode", required = false) String customerOrgCode);


    @ApiOperation(value = "修改客户组织")
    @PostMapping("/mdmCusOrgController/edit")
    Result<Object> edit(@RequestBody CusOrgVo cusOrgVo);

    @ApiOperation(value = "分页搜索客户组织")
    @PostMapping("/mdmCusOrgController/list")
    @CrmDictMethod
    Result<PageResult<CusOrgVo>> list(@RequestBody CusOrgVo cusOrgVo);

    @ApiOperation(value = "分页搜索客户组织")
    @PostMapping("/mdmCusOrgController/findList")
    @CrmDictMethod
    Result<List<CusOrgVo>> findList(@RequestBody CusOrgVo cusOrgVo);

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "根据id批量启用")
    @PostMapping("/mdmCusOrgController/enAbleBatch")
    Result<Object> enAbleBatch(@RequestBody List<String> ids);

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "根据id批量禁用")
    @PostMapping("/mdmCusOrgController/disAbleBatch")
    Result<Object> disAbleBatch(@RequestBody List<String> ids);

    @ApiImplicitParams({
            @ApiImplicitParam(name = "ids", value = "id集合", required = true, paramType = "body")
    })
    @ApiOperation(value = "根据id批量删除")
    @PostMapping("/mdmCusOrgController/delBatch")
    Result<Object> delBatch(@RequestBody List<String> ids);

    @ApiOperation("客户组织下拉框")
    @PostMapping("/mdmCusOrgController/select")
    Result<List<MdmCustomerOrgSelectRespVo>> customerOrgSelect(@RequestBody CusOrgVo cusOrgVo);

    @ApiModelProperty("重置物化路径编码")
    @PostMapping("/mdmCusOrgController/rule_code_set")
    Result<Object> setUpRuleCode();

}
