package com.biz.crm.mdm.customer;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.customer.impl.MdmCustomerAddressFeignImpl;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressRespVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.util.Result;

/**
 * 客户信息：收货地址feign接口
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmCustomerAddressFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmCustomerAddressFeignImpl.class)
public interface MdmCustomerAddressFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmcustomeraddress/list")
    Result<PageResult<MdmCustomerAddressRespVo>> list(@RequestBody MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmcustomeraddress/query")
    Result<MdmCustomerAddressRespVo> query(@RequestBody MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmcustomeraddress/save")
    Result save(@RequestBody MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmcustomeraddress/update")
    Result update(@RequestBody MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmcustomeraddress/delete")
    Result delete(@RequestBody MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmcustomeraddress/enable")
    Result enable(@RequestBody MdmCustomerAddressReqVo mdmCustomerAddressReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmcustomeraddress/disable")
    Result disable(@RequestBody  MdmCustomerAddressReqVo mdmCustomerAddressReqVo);
}
