package com.biz.crm.mdm.customer;

import com.biz.crm.activiti.common.CallbackFeign;
import com.biz.crm.mdm.customer.impl.MdmCustomerCallBackFeignImpl;
import com.biz.crm.nebular.activiti.act.ActivitiCallBackVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 客户信息审批回调feign接口
 *
 * @author huanglong
 * @date 2020-09-18 13:46:33
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmCustomerCallBackFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmCustomerCallBackFeignImpl.class)
public interface MdmCustomerCallBackFeign extends CallbackFeign {

    /**
     * 回调方法
     *
     * @param activitiCallBackVo
     * @return
     */
    @Override
    @PostMapping("/mdmCustomerMsgController/activityCallBack")
    Result callback(@RequestBody ActivitiCallBackVo activitiCallBackVo);
}
