package com.biz.crm.mdm.customer;

import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.mdm.customer.impl.MdmCustomerMsgFeignImpl;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * feign接口
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmCustomerMsgFeign",name="crm-mdm",path = "mdm",fallback = MdmCustomerMsgFeignImpl.class)
public interface MdmCustomerMsgFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmCustomerMsgController/page")
    Result<PageResult<MdmCustomerMsgRespVo>> list(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 查询
     */
    @GetMapping("/mdmCustomerMsgController/query")
    Result<MdmCustomerMsgRespVo> query(@RequestParam(value = "id",required = false) String id, @RequestParam(value = "customerCode",required = false) String customerCode);

    /**
     * 根据经销商编码查询经销商信息
     */
    @PostMapping("/mdmCustomerMsgController/queryByCustomerCodeList")
    Result<List<MdmCustomerMsgRespVo>> queryByCustomerCodeList(@RequestBody List<String> customerList);

    /**
     * 新增
     */
    @PostMapping("/mdmCustomerMsgController/save")
    Result<MdmCustomerMsgRespVo> save(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 新增并提交
     */
    @PostMapping("/mdmCustomerMsgController/saveAndSubmit")
    Result<Object> saveAndSubmit(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmCustomerMsgController/update")
    Result<Object> update(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmCustomerMsgController/delete")
    Result<Object> delete(@RequestBody List<String> ids);

    /**
     * 启用
     */
    @PostMapping("/mdmCustomerMsgController/enable")
    Result<Object> enable(@RequestBody List<String> ids);

    /**
     * 禁用
     */
    @PostMapping("/mdmCustomerMsgController/disable")
    Result<Object> disable(@RequestBody List<String> ids);


    @PostMapping("/mdmCustomerMsgController/findDetailsByFormInstanceId")
    Result<MdmCustomerMsgRespVo> findDetailsByFormInstanceId(String formInstanceId);

    @PostMapping("/mdmCustomerMsgController/updateOrgCodeByCondition")
    Result<Object> updateOrgCodeByCondition(@RequestBody MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo);

    @PostMapping("/mdmCustomerMsgController/findByOrgCodeList")
    Result<List<String>> findByOrgCodeList(@RequestBody List<String> list);

    /**
     * 根据组织编码查询当前及下级组织的客户
     * @param mdmCustomerOrgSearchReqVo
     * @return
     */
    @PostMapping("/mdmCustomerMsgController/findCurrentAndSubCustomerList")
    Result<List<MdmCustomerMsgRespVo>> findCurrentAndSubCustomerList(@RequestBody MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo);

    @ApiOperation(value = "查询客户下拉框列表")
    @PostMapping("/mdmCustomerMsgController/findCustomerSelectList")
    Result<List<MdmCustomerMsgSelectRespVo>> findCustomerSelectList(@RequestBody MdmCustomerMsgReqVo mdmCustomerMsgReqVo);

    @ApiOperation("对接人职位下拉框")
    @PostMapping("/mdmCustomerMsgController/dockingSearch")
    Result<List<MdmCustomerDockingRespVo>> dockingSearch(MdmCustomerDockingSearchReqVo mdmCustomerDockingSearchReqVo);

    /**
     * 条件查询客户编码
     * @param customerCodeConditionReqVo
     * @return
     */
    @PostMapping("/mdmCustomerMsgController/findCustomerCodeConditionList")
    Result<List<String>> findCustomerCodeConditionList(@RequestBody CustomerCodeConditionReqVo customerCodeConditionReqVo);

    @ApiOperation("当前及下级职位编码对应的客户集合")
    @PostMapping("/mdmCustomerMsgController/findCurrentAndSubPositionCustomer")
    Result<List<MdmCustomerMsgRespVo>> findCurrentAndSubPositionCustomer(@RequestBody MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo);


    /**
     * 分页查询列表及联系人
     * @param mdmCustomerContactPageReqVo
     * @return
     */
    @PostMapping("/mdmCustomerMsgController/listAndContactPage")
    Result<PageResult<MdmCustomerMsgRespVo>> listAndContactPage(@RequestBody MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo);


    @ApiOperation(value = "根据编码集合查询客户分页列表及主联系人")
    @PostMapping("/mdmCustomerMsgController/customerContactPage")
    Result<PageResult<MdmCustomerMsgContactPageRespVo>> customerContactPage(@RequestBody MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo);


    @ApiOperation(value = "SFA-根据编码集合查询客户分页列表及主联系人")
    @PostMapping("/mdmCustomerMsgController/sfaFindCustomerContactPage")
    Result<List<MdmCustomerMsgContactPageRespVo>> sfaFindCustomerContactPage(@RequestBody List<String> customerCodes);

    @ApiImplicitParams({
            @ApiImplicitParam(name = "mdmCustomerMsgReqVos", value = "客户集合", required = true, paramType = "body")
    })
    @ApiOperation("根据客户编码集合修改经纬度")
    @PostMapping("/mdmCustomerMsgController/updateCoordinate")
    Result<Object> updateCoordinate(@RequestBody List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos);

    @ApiOperation("查询职位关联的客户数量")
    @GetMapping("/mdmCustomerMsgController/findPositionRelationCustomerCount")
    Result<Integer> findPositionRelationCustomerCount(@RequestParam("positionCode") String positionCode);

    @ApiOperation("查询职位关联的客户数量")
    @GetMapping("/mdmCustomerMsgController/findCurrentPositionRelationCustomerCount")
    Result<Integer> findCurrentPositionRelationCustomerCount(@RequestParam("positionCode") String positionCode);

    @ApiOperation(value = "条件查询客户主联系人及距离分页列表")
    @PostMapping("/mdmCustomerMsgController/distanceContactPage")
    Result<PageResult<MdmCustomerContactPageRespVo>> distanceContactPage(@RequestBody MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo);

    @ApiOperation(value = "条件查询客户主联系人及距离分页列表（可以查到非审批通过的）")
    @PostMapping("/mdmCustomerMsgController/distanceContactNoBpmFilterPage")
    Result<PageResult<MdmCustomerContactPageRespVo>> distanceContactNoBpmFilterPage(@RequestBody MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo);

    @ApiOperation("根据当前组织编码集合查询当前及下级组织对应的客户")
    @PostMapping("/mdmCustomerMsgController/findSubCustomerList")
    Result<List<MdmCustomerMsgRespVo>> findSubCustomerList(@RequestBody MdmCustomerAndOrgReqVo mdmCustomerOrgSearchReqVo);

    @ApiOperation("根据客户组织编码集合查询客户组织下的经销商")
    @PostMapping("/mdmCustomerMsgController/findCustomerByCustomerOrgCodeList")
    Result<List<MdmCustomerMsgRespVo>> findCustomerByCustomerOrgCodeList(@RequestBody List<String> customerOrgCodeList);

    @ApiOperation(value = "根据终端编/客户编码list查询标签")
    @PostMapping("/mdmCustomerTagController/queryTagByCodeList")
    Result<List<MdmCustomerTagRespVo>> queryTagByCodeList( @RequestBody List<String> customerCodeList) ;
}
