package com.biz.crm.mdm.customer.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.customer.MdmCustomerAddressFeign;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerAddressRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 客户信息：收货地址feign接口熔断类
 *
 * @author zxw
 * @date 2020-09-10 12:09:54
 */
@Slf4j
@Component
public class MdmCustomerAddressFeignImpl extends BaseAbstract implements FallbackFactory<MdmCustomerAddressFeign> {

    @Override
    public MdmCustomerAddressFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmCustomerAddressFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmCustomerAddressRespVo>> list(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
                doBack();
                PageResult<MdmCustomerAddressRespVo> build = PageResult.<MdmCustomerAddressRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmCustomerAddressRespVo> query(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmCustomerAddressReqVo mdmCustomerAddressReqVo) {
                return doBack();
            }
        };
    }
}
