package com.biz.crm.mdm.customer.impl;


import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.customer.MdmCustomerMsgFeign;
import com.biz.crm.nebular.mdm.customer.*;
import com.biz.crm.nebular.mdm.customer.CustomerCodeConditionReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgReqVo;
import com.biz.crm.nebular.mdm.customer.MdmCustomerMsgRespVo;
import com.biz.crm.nebular.mdm.customer.MdmUpdateCusOrgCodeReqVo;
import com.biz.crm.nebular.mdm.humanarea.MdmCustomerOrgSearchReqVo;
import com.biz.crm.util.Result;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;

/**
 * feign接口熔断类
 *
 * @author zxw
 * @date 2020-09-02 14:10:25
 */
@Slf4j
@Component
public class MdmCustomerMsgFeignImpl extends BaseAbstract implements MdmCustomerMsgFeign {

    /**
     * 列表
     */
    @Override
    public Result list(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return doBack();
    }

    /**
     * 查询
     */
    @Override
    public Result query(@RequestParam(value = "id",required = false) String id, @RequestParam(value = "customerCode",required = false) String customerCode) {
        return doBack();
    }

    @Override
    public Result<List<MdmCustomerMsgRespVo>> queryByCustomerCodeList(@RequestBody List<String> customerList) {
        return doBack();
    }


    /**
     * 新增
     */
    @Override
    public Result<MdmCustomerMsgRespVo> save(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return doBack();
    }

    @Override
    public Result<Object> saveAndSubmit(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return doBack();
    }

    /**
     * 更新
     */
    @Override
    public Result update(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return doBack();
    }

    /**
     * 删除
     */
    @Override
    public Result delete(@RequestBody List<String> ids) {
        return doBack();
    }

    /**
     * 启用
     */
    @Override
    public Result enable(@RequestBody List<String> ids) {
        return doBack();
    }

    /**
     * 禁用
     */
    @Override
    public Result disable(@RequestBody List<String> ids) {
        return doBack();
    }

    @Override
    public Result findDetailsByFormInstanceId(String formInstanceId) {
        return doBack();
    }

    @Override
    public Result<Object> updateOrgCodeByCondition(MdmUpdateCusOrgCodeReqVo mdmUpdateCusOrgCodeReqVo) {
        return doBack();
    }

    @Override
    public Result<List<String>> findByOrgCodeList(List<String> list) {
        return doBack();
    }

    /**
     * 根据组织编码查询当前及下级组织的客户
     * @param mdmCustomerOrgSearchReqVo
     * @return
     */
    @Override
    public Result<List<MdmCustomerMsgRespVo>> findCurrentAndSubCustomerList(MdmCustomerOrgSearchReqVo mdmCustomerOrgSearchReqVo) {
        return doBack();
    }

    @Override
    public Result<List<MdmCustomerMsgSelectRespVo>> findCustomerSelectList(MdmCustomerMsgReqVo mdmCustomerMsgReqVo) {
        return doBack();
    }

    @Override
    public Result<List<MdmCustomerDockingRespVo>> dockingSearch(MdmCustomerDockingSearchReqVo mdmCustomerDockingSearchReqVo) {
        return doBack();
    }

    /**
     * 条件查询客户编码
     *
     * @param customerCodeConditionReqVo
     * @return
     */
    @Override
    public Result<List<String>> findCustomerCodeConditionList(CustomerCodeConditionReqVo customerCodeConditionReqVo) {
        return doBack();
    }

    @Override
    public Result<List<MdmCustomerMsgRespVo>> findCurrentAndSubPositionCustomer(MdmPositionCustomerSearchReqVo mdmPositionCustomerSearchReqVo) {
        return doBack();
    }

    @Override
    public Result<PageResult<MdmCustomerMsgRespVo>> listAndContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        return doBack();
    }

    @Override
    public Result<PageResult<MdmCustomerMsgContactPageRespVo>> customerContactPage(MdmCustomerContactPageReqVo mdmCustomerContactPageReqVo) {
        return doBack();
    }

    @Override
    public Result<List<MdmCustomerMsgContactPageRespVo>> sfaFindCustomerContactPage(List<String> customerCodes) {
        return doBack();
    }

    @Override
    public Result<Object> updateCoordinate(List<MdmCustomerMsgReqVo> mdmCustomerMsgReqVos) {
        return doBack();
    }

    @Override
    public Result<Integer> findPositionRelationCustomerCount(String positionCode) {
        return doBack();
    }

    @Override
    public Result<Integer> findCurrentPositionRelationCustomerCount(String positionCode) {
        return doBack();
    }

    @Override
    public Result<PageResult<MdmCustomerContactPageRespVo>> distanceContactPage(MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        return doBack();
    }

    @Override
    public Result<PageResult<MdmCustomerContactPageRespVo>> distanceContactNoBpmFilterPage(MdmCustomerDistanceContactPageReqVo mdmCustomerDistanceContactPageReqVo) {
        return doBack();
    }

    @Override
    public Result<List<MdmCustomerMsgRespVo>> findSubCustomerList(MdmCustomerAndOrgReqVo mdmCustomerOrgSearchReqVo) {
        return doBack();
    }

    @Override
    public Result<List<MdmCustomerMsgRespVo>> findCustomerByCustomerOrgCodeList(List<String> customerOrgCodeList) {
        return doBack();
    }

    @Override
    public Result<List<MdmCustomerTagRespVo>> queryTagByCodeList(List<String> customerCodeList) {
        return doBack();
    }

}
