package com.biz.crm.mdm.customermaterial.impl;

import lombok.extern.slf4j.Slf4j;
import com.biz.crm.nebular.mdm.customermaterial.resp.MdmCustomerMaterialRespVo;
import com.biz.crm.nebular.mdm.customermaterial.req.MdmCustomerMaterialReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import com.biz.crm.base.BaseAbstract;
import org.springframework.stereotype.Component;
import com.biz.crm.mdm.customermaterial.MdmCustomerMaterialFeign;
import feign.hystrix.FallbackFactory;

/**
 * 客户物料feign接口熔断类
 *
 * @author huang.long
 * @date 2020-09-03 10:26:02
 */
@Slf4j
@Component
public class MdmCustomerMaterialFeignImpl extends BaseAbstract implements FallbackFactory<MdmCustomerMaterialFeign> {

    @Override
    public MdmCustomerMaterialFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmCustomerMaterialFeign() {
             /**
              * 列表
              */
            @Override
            public Result list(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
                return doBack();
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmCustomerMaterialRespVo> query(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmCustomerMaterialReqVo mdmCustomerMaterialReqVo) {
                return doBack();
            }
        };
    }
}
