package com.biz.crm.mdm.engineform;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.engineform.impl.EngineFormListTemplateFeignImpl;
import com.biz.crm.nebular.mdm.engineform.req.EngineFormListTemplateReqVo;
import com.biz.crm.nebular.mdm.engineform.resp.EngineFormListTemplateRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 表单引擎模板的数据层描述feign接口
 *
 * @author huanglong
 * @date 2020-11-17 09:25:34
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "EngineFormListTemplateFeign", name = "crm-mdm", path = "mdm", fallbackFactory = EngineFormListTemplateFeignImpl.class)
public interface EngineFormListTemplateFeign {

    /**
     * 列表
     */
    @PostMapping("/engineformlisttemplate/list")
    Result<PageResult<EngineFormListTemplateRespVo>> list(@RequestBody EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 查询
     */
    @PostMapping("/engineformlisttemplate/query")
    Result<EngineFormListTemplateRespVo> query(@RequestBody EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 新增
     */
    @PostMapping("/engineformlisttemplate/save")
    Result save(@RequestBody EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 更新
     */
    @PostMapping("/engineformlisttemplate/update")
    Result update(@RequestBody EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 删除
     */
    @PostMapping("/engineformlisttemplate/delete")
    Result delete(@RequestBody EngineFormListTemplateReqVo engineFormListTemplateReqVo);

    /**
     * 活动大类-申请表单列表
     */
    @PostMapping("/activityFormList")
    Result activityFormList();


}
