package com.biz.crm.mdm.function;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.function.impl.MdmFunctionFeignImpl;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.util.Result;

import java.util.List;

/**
 * 菜单表feign接口
 *
 * @author zxw
 * @date 2020-11-18 10:26:31
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmFunctionFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmFunctionFeignImpl.class)
public interface MdmFunctionFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmfunction/list")
    Result<List<MdmFunctionRespVo>> list(@RequestBody MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmfunction/query")
    Result<MdmFunctionRespVo> query(@RequestBody MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmfunction/save")
    Result save(@RequestBody MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmfunction/update")
    Result update(@RequestBody MdmFunctionReqVo mdmFunctionReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmfunction/delete")
    Result delete(@RequestBody MdmFunctionReqVo mdmFunctionReqVo);

}
