package com.biz.crm.mdm.functionrole;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.functionrole.impl.MdmFunctionRoleFeignImpl;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleReqVo;
import com.biz.crm.nebular.mdm.functionrole.MdmFunctionRoleRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 职位级别-角色关联表feign接口
 *
 * @author zxw
 * @date 2020-11-18 10:42:36
 */


@FeignClient(url = "${feign.urlip:}", qualifier = "MdmFunctionRoleFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmFunctionRoleFeignImpl.class)
public interface MdmFunctionRoleFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmfunctionrole/list")
    Result<PageResult<MdmFunctionRoleRespVo>> list(@RequestBody MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmfunctionrole/query")
    Result<MdmFunctionRoleRespVo> query(@RequestBody MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmfunctionrole/save")
    Result save(@RequestBody MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmfunctionrole/update")
    Result update(@RequestBody MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmfunctionrole/delete")
    Result delete(@RequestBody MdmFunctionRoleReqVo mdmFunctionRoleReqVo);

}
