package com.biz.crm.mdm.map.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.map.MdmTerminalCustomerElasticsearchFeign;
import com.biz.crm.nebular.mdm.terminal.req.MdmTerminalCustomerElasticsearchPageReqVo;
import com.biz.crm.nebular.mdm.terminal.resp.MdmTerminalCustomerElasticsearchRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;

/**
 * 客户和终端Elasticsearch feign接口
 *
 * @author yangshan
 * @date 2021-3-10 15:20:25
 */
@Slf4j
@Component
public class MdmTerminalCustomerElasticsearchFeignImpl extends BaseAbstract implements FallbackFactory<MdmTerminalCustomerElasticsearchFeign> {

    @Override
    public MdmTerminalCustomerElasticsearchFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
       return new MdmTerminalCustomerElasticsearchFeign(){
           @Override
           public Result<PageResult<MdmTerminalCustomerElasticsearchRespVo>> list(MdmTerminalCustomerElasticsearchPageReqVo pageReqVo) {
               doBack();
               PageResult<MdmTerminalCustomerElasticsearchRespVo> build = PageResult.<MdmTerminalCustomerElasticsearchRespVo>builder()
                       .data(new ArrayList<>())
                       .count(0L)
                       .build();
               return Result.ok(build);
           }
       };
    }
}
