package com.biz.crm.mdm.mdmbuglistmanagement;

import com.biz.crm.mdm.mdmbuglistmanagement.impl.MdmBugListManagementFeignImpl;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.req.MdmBugListManagementReqVo;
import com.biz.crm.nebular.mdm.mdmbuglistmanagement.resp.MdmBugListManagementRespVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

/**
 * bug管理主表feign接口
 *
 * @author lf
 * @date 2021-01-29 11:23:29
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmBugListManagementFeign",name="crm-mdm",path = "tpm",fallbackFactory = MdmBugListManagementFeignImpl.class)
public interface MdmBugListManagementFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmbuglistmanagement/list")
    Result<PageResult<MdmBugListManagementRespVo>> list(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmbuglistmanagement/query")
    Result<MdmBugListManagementRespVo> query(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmbuglistmanagement/save")
    Result save(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmbuglistmanagement/update")
    Result update(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmbuglistmanagement/delete")
    Result delete(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmbuglistmanagement/enable")
    Result enable(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmbuglistmanagement/disable")
    Result disable(@RequestBody MdmBugListManagementReqVo mdmBugListManagementReqVo);
}
