package com.biz.crm.mdm.newhope;

import com.biz.crm.mdm.newhope.impl.NewHopeOrgSyncFeignImpl;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author maoshen
 * @date 2021/6/11.
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "NewHopeOrgSyncFeign", name = "crm-mdm", path = "mdm", fallbackFactory = NewHopeOrgSyncFeignImpl.class)
public interface NewHopeOrgSyncFeign {

    /**
     * 组织同步
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/orgSyncController/orgSyncAll")
    Result orgSyncAll(NewHopeReqVo reqVo);

    /**
     * 组织增量
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/orgSyncController/orgSyncIncrement")
    Result orgSyncIncrement(NewHopeReqVo reqVo);
}
