package com.biz.crm.mdm.newhope;

import com.biz.crm.mdm.newhope.impl.NewHopeUserSyncFeignImpl;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;

/**
 * @author maoshen
 * @date 2021/6/11.
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "NewHopeUserSyncFeign", name = "crm-mdm", path = "mdm", fallbackFactory = NewHopeUserSyncFeignImpl.class)
public interface NewHopeUserSyncFeign {

    /**
     * 用户同步
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/userSyncController/userSync")
    Result userSyncAll(NewHopeReqVo reqVo);

    /**
     * 用户增量
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/userSyncController/userSyncIncrement")
    Result userSyncIncrement(NewHopeReqVo reqVo);
}
