package com.biz.crm.mdm.newhope.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.newhope.NewHopeOrgSyncFeign;
import com.biz.crm.nebular.mdm.newhope.req.NewHopeReqVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

/**
 * @author maoshen
 * @date 2021/6/11.
 */
@Slf4j
@Component
public class NewHopeOrgSyncFeignImpl extends BaseAbstract implements FallbackFactory<NewHopeOrgSyncFeign> {

    @Override
    public NewHopeOrgSyncFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new NewHopeOrgSyncFeign() {

            @Override
            public Result orgSyncAll(NewHopeReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result orgSyncIncrement(NewHopeReqVo reqVo) {
                return doBack();
            }
        };
    }
}
