package com.biz.crm.mdm.permission;


import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.permission.impl.MdmListConfigFeignImpl;
import com.biz.crm.nebular.mdm.permission.MdmListConfigReqVo;
import com.biz.crm.nebular.mdm.permission.MdmListConfigRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * feign接口
 *
 * @author zxw
 * @date 2020-10-26 10:42:33
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmListConfigFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmListConfigFeignImpl.class)
public interface MdmListConfigFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmlistconfig/list")
    Result<PageResult<MdmListConfigRespVo>> list(@RequestBody MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmlistconfig/query")
    Result<MdmListConfigRespVo> query(@RequestBody MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmlistconfig/save")
    Result save(@RequestBody MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmlistconfig/update")
    Result update(@RequestBody MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmlistconfig/delete")
    Result delete(@RequestBody MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmlistconfig/enable")
    Result enable(@RequestBody MdmListConfigReqVo mdmListConfigReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmlistconfig/disable")
    Result disable(@RequestBody  MdmListConfigReqVo mdmListConfigReqVo);
}
