package com.biz.crm.mdm.permission.impl;


import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.permission.MdmDataPermissionFeign;
import com.biz.crm.nebular.mdm.permission.MdmCurrentPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionReqVo;
import com.biz.crm.nebular.mdm.permission.MdmDataPermissionRespVo;
import com.biz.crm.nebular.mdm.permission.MdmPermissionSetVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * 数据权限feign接口熔断类
 *
 * @author zxw
 * @date 2020-10-26 12:09:31
 */
@Slf4j
@Component
public class MdmDataPermissionFeignImpl extends BaseAbstract implements FallbackFactory<MdmDataPermissionFeign> {

    @Override
    public MdmDataPermissionFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmDataPermissionFeign() {
            /**
             * 列表
             */
            @Override
            public Result<PageResult<MdmDataPermissionRespVo>> list(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
                doBack();
                PageResult<MdmDataPermissionRespVo> build = PageResult.<MdmDataPermissionRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmDataPermissionRespVo> query(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmDataPermissionReqVo mdmDataPermissionReqVo) {
                return doBack();
            }

            @Override
            public Result<MdmCurrentPermissionRespVo> currentUserDataPermission(String competenceCode, String listConfigCode) {
                return doBack();
            }

            @Override
            public Result<List<MdmPermissionSetVo>> currentUserPermissionSql() {
                return doBack();
            }
        };
    }
}
