package com.biz.crm.mdm.permission.impl;


import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.permission.MdmPermissionFeign;
import com.biz.crm.nebular.mdm.permission.*;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * feign接口熔断类
 *
 * @author zxw
 * @date 2020-10-26 10:42:33
 */
@Slf4j
@Component
public class MdmPermissionFeignImpl extends BaseAbstract implements FallbackFactory<MdmPermissionFeign> {

    @Override
    public MdmPermissionFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmPermissionFeign() {
             /**
              * 列表
              */
            @Override
            public Result<PageResult<MdmPermissionRespVo>> list(MdmPermissionReqVo mdmPermissionReqVo) {
                doBack();
                PageResult<MdmPermissionRespVo> build = PageResult.<MdmPermissionRespVo>builder()
                        .data(new ArrayList<>())
                        .count(0L)
                        .build();
                return Result.ok(build);
            }

            /**
             * 查询
             */
            @Override
            public Result<MdmPermissionRespVo> query(MdmPermissionReqVo mdmPermissionReqVo) {
                return doBack();
            }

            /**
             * 新增
             */
            @Override
            public Result save(MdmPermissionReqVo mdmPermissionReqVo) {
                return doBack();
            }

            /**
             * 更新
             */
            @Override
            public Result update(MdmPermissionReqVo mdmPermissionReqVo) {
                return doBack();
            }

            /**
             * 删除
             */
            @Override
            public Result delete(MdmPermissionReqVo mdmPermissionReqVo) {
                return doBack();
            }

            /**
             * 启用
             */
            @Override
            public Result enable(MdmPermissionReqVo mdmPermissionReqVo) {
                return doBack();
            }

            /**
             * 禁用
             */
            @Override
            public Result disable(MdmPermissionReqVo mdmPermissionReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmListConfigRespVo>> configList(MdmListConfigReqVo mdmListConfigReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmPermissionMenuRespVo>> menuList(MdmPermissionModelReqVo mdmPermissionModelReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmPermissionObjRespVo>> objList(MdmPermissionReqVo mdmPermissionReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmPermissionSearchTypeVo>> searchTypeList(MdmPermissionSearchTypeVo mdmPermissionSearchTypeVo) {
                return doBack();
            }

            @Override
            public Result<Object> saveObj(MdmPermissionObjReqVo mdmPermissionObjReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmPermissionSubModelRespVo>> menuSelect(MdmPermissionModelReqVo mdmPermissionModelReqVo) {
                return doBack();
            }
        };
    }
}
