package com.biz.crm.mdm.poi;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.poi.impl.MdmAmapPoiFeignImpl;
import com.biz.crm.nebular.mdm.poi.req.MdmAmapPoiDistanceReqVo;
import com.biz.crm.nebular.mdm.poi.resp.MdmAmapPoiDistanceRespVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

/**
 * 高德POI
 *
 * @author Tao.Chen
 * @date 2021-05-10 22:44:52
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmAmapPoiFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmAmapPoiFeignImpl.class)
public interface MdmAmapPoiFeign {

    @PostMapping("/mdmAmapPoiController/queryAndUpdate")
    Result queryAndUpdate();

    @PostMapping("/mdmAmapPoiController/findAmapPoiDistancePageList")
    Result<PageResult<MdmAmapPoiDistanceRespVo>> findAmapPoiDistancePageList(@RequestBody MdmAmapPoiDistanceReqVo reqVo);

}
