package com.biz.crm.mdm.position;

import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.position.impl.MdmPositionFeignImpl;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.*;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestParam;

import java.util.List;
import java.util.Set;

/**
 * 职位表feign接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmPositionFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmPositionFeignImpl.class)
public interface MdmPositionFeign {

    /**
     * 根据职位id或者职位编码查询职位主表，以及职位关联用户、组织、角色、流程角色，查询数据较多，请谨慎使用
     */
    @GetMapping("/mdmPositionController/getPositionDetail")
    Result<MdmPositionDetailRespVo> getPositionDetail(@RequestParam("id") String id, @RequestParam("positionCode") String positionCode);

    /**
     * 通过职位id集合批量查询职位及关联、用户、组织、上级职位信息
     */
    @PostMapping("/mdmPositionController/detailBatchByIds")
    Result<List<MdmPositionUserOrgRespVo>> detailBatchByIds(@RequestBody List<String> ids);

    /**
     * 通过职位编码集合批量查询职位及关联、用户、组织、上级职位信息
     */
    @PostMapping("/mdmPositionController/detailBatchByPositionCodeList")
    Result<List<MdmPositionUserOrgRespVo>> detailBatchByPositionCodeList(@RequestBody List<String> positionCodeList);

    /**
     * 根据userName获取用户主职位
     */
    @GetMapping("/mdmPositionController/getPrimaryPositionByUserName")
    Result<MdmPositionRespVo> getPrimaryPositionByUserName(@RequestParam("userName") String userName);

    /**
     * 根据userName获取用户全部职位
     */
    @PostMapping("/mdmPositionController/getUserAllPositionList")
    Result<List<MdmPositionRespVo>> getUserAllPositionList(@RequestBody MdmUserReqVo reqVo);

    /**
     * 切换用户主职位
     */
    @Deprecated
    @PostMapping("/mdmPositionController/changeUserPrimaryPosition")
    Result changeUserPrimaryPosition(@RequestBody MdmPositionReqVo reqVo);

    /**
     * 切换用户当前职位
     */
    @PostMapping("/mdmPositionController/changeUserCurrentPosition")
    Result changeUserCurrentPosition(@RequestBody MdmPositionReqVo reqVo);

    /**
     * 根据职位编码查询职位及关联用户、组织、上级信息
     */
    @GetMapping("/mdmPositionController/getPositionUserOrgByPositionCode")
    Result<MdmPositionUserOrgRespVo> getPositionUserOrgByPositionCode(@RequestParam("positionCode") String positionCode);

    /**
     * 批量查询以职位维度的职位及关联用户、组织、上级信息
     */
    @PostMapping("/mdmPositionController/findPositionUserOrgList")
    Result<List<MdmPositionUserOrgRespVo>> findPositionUserOrgList(@RequestBody MdmPositionUserOrgReqVo reqVo);

    /**
     * 批量查询以职位维度的职位及关联用户、组织、上级信息（分页）
     */
    @PostMapping("/mdmPositionController/findPositionUserOrgPageList")
    Result<PageResult<MdmPositionUserOrgPageRespVo>> findPositionUserOrgPageList(@RequestBody MdmPositionUserOrgPageReqVo reqVo);

    /**
     * 重置职位降维编码（全表更新）
     */
    @PostMapping("/mdmPositionController/resetPositionRuleCode")
    Result resetPositionRuleCode();

    /**
     * 根据流程角色编码查询职位，按照组织从指定组织向上寻址
     *
     * @param orgCode     组织编码
     * @param bpmRoleCode 流程角色编码
     * @return
     */
    @GetMapping("/mdmPositionController/findPositionListByBpmRoleStartUpByOrgCode")
    Result<List<MdmPositionUserOrgRespVo>> findPositionListByBpmRoleStartUpByOrgCode(@RequestParam("orgCode") String orgCode, @RequestParam("bpmRoleCode") String bpmRoleCode);

    /**
     * 根据流程角色编码查询职位，按照组织及上级组织查询
     *
     * @param orgCode         组织编码（非必填）
     * @param bpmRoleCodeList 流程角色编码
     * @return
     */
    @PostMapping("/mdmPositionController/findPositionCodeSetByOrgParentAndBpmRoleCodeList")
    Result<Set<String>> findPositionCodeSetByOrgParentAndBpmRoleCodeList(@RequestParam(value = "orgCode",required = false) String orgCode, @RequestBody List<String> bpmRoleCodeList);

    /**
     * 根据流程角色编码查询职位，按照组织查询
     *
     * @param orgCode         组织编码（非必填）
     * @param bpmRoleCodeList 流程角色编码
     * @return
     */
    @PostMapping("/mdmPositionController/findPositionCodeSetByOrgAndBpmRoleCodeList")
    Result<Set<String>> findPositionCodeSetByOrgAndBpmRoleCodeList(@RequestParam(value = "orgCode", required = false) String orgCode, @RequestBody List<String> bpmRoleCodeList);


    /**
     * 查询职位查询
     *
     * @param id           id
     * @param positionCode 职位编码
     * @return vo
     */
    @GetMapping("/mdmPositionController/detail")
    Result<MdmPositionRespVo> detail(@RequestParam(value = "id", required = false) String id, @RequestParam(value = "positionCode", required = false) String positionCode);


    @ApiOperation(value = "职位与用户分页列表(SFA)")
    @PostMapping("/mdmPositionController/positionAndUserPage")
    Result<PageResult<MdmPositionPageRespVo>> positionAndUserPage(@RequestBody MdmPositionPageReqVo reqVo);
}
