package com.biz.crm.mdm.position;

import com.biz.crm.mdm.position.impl.MdmPositionRedisFeignImpl;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionParentChildrenRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionRedisVo;
import com.biz.crm.nebular.mdm.position.resp.MdmPositionReloadRedisVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 职位表redis缓存数据查询feign接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmPositionRedisFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmPositionRedisFeignImpl.class)
public interface MdmPositionRedisFeign {

    /**
     * 根据职位编码集合获取职位详情redis缓存数据
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmPositionRedisController/findRedisListByPositionCodeList")
    Result<List<MdmPositionRedisVo>> findRedisListByPositionCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 根据职位编码集合获取职位上级redis缓存数据
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmPositionRedisController/findRedisPositionParentListByCodeList")
    Result<List<MdmPositionParentChildrenRedisVo>> findRedisPositionParentListByCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 根据职位编码集合获取职位下级redis缓存数据
     *
     * @param orgCodeList
     * @return
     */
    @PostMapping("/mdmPositionRedisController/findRedisPositionChildrenListByCodeList")
    Result<List<MdmPositionParentChildrenRedisVo>> findRedisPositionChildrenListByCodeList(@RequestBody List<String> orgCodeList);

    /**
     * 获取全部职位redis缓存数据
     *
     * @return
     */
    @PostMapping("/mdmPositionRedisController/findRedisReloadList")
    Result<List<MdmPositionReloadRedisVo>> findRedisReloadList();
}
