package com.biz.crm.mdm.position.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.position.MdmPositionFeign;
import com.biz.crm.nebular.mdm.position.req.MdmPositionPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgPageReqVo;
import com.biz.crm.nebular.mdm.position.req.MdmPositionUserOrgReqVo;
import com.biz.crm.nebular.mdm.position.resp.*;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;
import java.util.Set;

/**
 * 职位表feign接口熔断类
 *
 * @author Tao.Chen
 * @date 2020-11-17 20:23:13
 */
@Slf4j
@Component
public class MdmPositionFeignImpl extends BaseAbstract implements FallbackFactory<MdmPositionFeign> {

    @Override
    public MdmPositionFeign create(Throwable throwable) {
        log.error("进入熔断", throwable);
        return new MdmPositionFeign() {

            @Override
            public Result<MdmPositionDetailRespVo> getPositionDetail(String id, String positionCode) {
                return doBack();
            }

            @Override
            public Result<List<MdmPositionUserOrgRespVo>> detailBatchByIds(List<String> ids) {
                return doBack();
            }

            @Override
            public Result<List<MdmPositionUserOrgRespVo>> detailBatchByPositionCodeList(List<String> positionCodeList) {
                return doBack();
            }

            @Override
            public Result<MdmPositionRespVo> getPrimaryPositionByUserName(String userName) {
                return doBack();
            }

            @Override
            public Result<List<MdmPositionRespVo>> getUserAllPositionList(MdmUserReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result changeUserPrimaryPosition(MdmPositionReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result changeUserCurrentPosition(MdmPositionReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<MdmPositionUserOrgRespVo> getPositionUserOrgByPositionCode(String positionCode) {
                return doBack();
            }

            @Override
            public Result<List<MdmPositionUserOrgRespVo>> findPositionUserOrgList(MdmPositionUserOrgReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmPositionUserOrgPageRespVo>> findPositionUserOrgPageList(MdmPositionUserOrgPageReqVo reqVo) {
                return doBack();
            }

            @Override
            public Result resetPositionRuleCode() {
                return doBack();
            }

            @Override
            public  Result<List<MdmPositionUserOrgRespVo>> findPositionListByBpmRoleStartUpByOrgCode(String orgCode, String bpmRoleCode) {
                return doBack();
            }

            @Override
            public Result<Set<String>> findPositionCodeSetByOrgParentAndBpmRoleCodeList(String orgCode, List<String> bpmRoleCodeList) {
                return doBack();
            }

            @Override
            public Result<Set<String>> findPositionCodeSetByOrgAndBpmRoleCodeList(String orgCode, List<String> bpmRoleCodeList) {
                return doBack();
            }

            @Override
            public Result<MdmPositionRespVo> detail(String id, String positionCode) {
                return doBack();
            }

            @Override
            public Result<PageResult<MdmPositionPageRespVo>> positionAndUserPage(MdmPositionPageReqVo reqVo) {
                return doBack();
            }
        };
    }
}
