package com.biz.crm.mdm.priceconditiontype;

import com.biz.crm.mdm.priceconditiontype.impl.MdmPriceConditionTypeFeignImpl;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRelGroupRespVo;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

import java.util.List;


/**
 * 条件字段类型主表 feign接口
 *
 * @author huanglong
 * @date 2020-10-20 10:57:00
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmPriceConditionTypeFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmPriceConditionTypeFeignImpl.class)
public interface MdmPriceConditionTypeFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmpriceconditiontype/list")
    Result<PageResult<MdmPriceConditionTypeRespVo>> list(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmpriceconditiontype/query")
    Result<MdmPriceConditionTypeRespVo> query(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmpriceconditiontype/save")
    Result save(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmpriceconditiontype/update")
    Result update(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmpriceconditiontype/delete")
    Result delete(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmpriceconditiontype/enable")
    Result enable(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmpriceconditiontype/disable")
    Result disable(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);

    /**
     * 根据条件类型编码查询条件分类数据
     */
    @PostMapping("/mdmpriceconditiontype/groupByConditionType")
    Result<List<MdmPriceConditionTypeRelGroupRespVo>> groupByConditionType(@RequestBody MdmPriceConditionTypeReqVo mdmPriceConditionTypeReqVo);
}
