package com.biz.crm.mdm.priceconditiontype;

import com.biz.crm.mdm.priceconditiontype.impl.MdmPriceConditionTypeRelGroupFeignImpl;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceConditionTypeRelGroupRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceConditionTypeRelGroupReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;

/**
 * 条件字段类型和条件字段分类的关系表 feign接口
 *
 * @author huanglong
 * @date 2020-10-20 10:57:01
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmPriceConditionTypeRelGroupFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmPriceConditionTypeRelGroupFeignImpl.class)
public interface MdmPriceConditionTypeRelGroupFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmpriceconditiontyperelgroup/list")
    Result<PageResult<MdmPriceConditionTypeRelGroupRespVo>> list(@RequestBody MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmpriceconditiontyperelgroup/query")
    Result<MdmPriceConditionTypeRelGroupRespVo> query(@RequestBody MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmpriceconditiontyperelgroup/save")
    Result save(@RequestBody MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmpriceconditiontyperelgroup/update")
    Result update(@RequestBody MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmpriceconditiontyperelgroup/delete")
    Result delete(@RequestBody MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmpriceconditiontyperelgroup/enable")
    Result enable(@RequestBody MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmpriceconditiontyperelgroup/disable")
    Result disable(@RequestBody MdmPriceConditionTypeRelGroupReqVo mdmPriceConditionTypeRelGroupReqVo);
}
