package com.biz.crm.mdm.pricesetting;

import com.biz.crm.mdm.pricesetting.impl.MdmPriceSettingFeignImpl;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSearchReqVo;
import java.util.Map;

import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceResp;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;
import com.biz.crm.nebular.mdm.pricesetting.resp.MdmPriceSettingRespVo;
import com.biz.crm.nebular.mdm.pricesetting.req.MdmPriceSettingReqVo;
import com.biz.crm.common.PageResult;
import com.biz.crm.util.Result;
import javax.validation.Valid;

/**
 * 价格维护主表 feign接口
 *
 * @author huanglong
 * @date 2020-10-20 13:49:03
 */


@FeignClient(url ="${feign.urlip:}",qualifier = "MdmPriceSettingFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmPriceSettingFeignImpl.class)
public interface MdmPriceSettingFeign {

    /**
     * 列表
     */
    @PostMapping("/mdmpricesetting/list")
    Result<PageResult<MdmPriceSettingRespVo>> list(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 查询
     */
    @PostMapping("/mdmpricesetting/query")
    Result<MdmPriceSettingRespVo> query(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 新增
     */
    @PostMapping("/mdmpricesetting/save")
    Result save(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 更新
     */
    @PostMapping("/mdmpricesetting/update")
    Result update(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 删除
     */
    @PostMapping("/mdmpricesetting/delete")
    Result delete(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 启用
     */
    @PostMapping("/mdmpricesetting/enable")
    Result enable(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 禁用
     */
    @PostMapping("/mdmpricesetting/disable")
    Result disable(@RequestBody MdmPriceSettingReqVo mdmPriceSettingReqVo);

    /**
     * 价格查询
     * @param mdmPriceSearchReqVo
     * @return
     */
    @PostMapping("/mdmPriceSettingController/search")
    Result<Map<String, Map<String, MdmPriceResp>>> search(@RequestBody MdmPriceSearchReqVo mdmPriceSearchReqVo);

    /**
     * 询价
     * @param mdmPriceSearchReqVo
     * @return
     */
    @PostMapping("/mdmPriceSettingController/inquiry")
    public Result<Map<String, Map<String, MdmPriceResp>>> inquiry(@RequestBody MdmPriceSearchReqVo mdmPriceSearchReqVo) ;
}
