package com.biz.crm.mdm.shoppingcart;

import com.biz.crm.mdm.shoppingcart.impl.ShoppingCartFeignImpl;
import com.biz.crm.nebular.mdm.shoppingcart.ShoppingCartVo;
import com.biz.crm.util.Result;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 购物车feign接口
 *
 * @author heyijiang
 * @date 2020/10/20 16:33
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "ShoppingCartFeign",name="crm-mdm",path = "mdm",fallbackFactory = ShoppingCartFeignImpl.class)
public interface ShoppingCartFeign {

    /**
     * 根据发货公司编码列表展示用户购物车信息
     * @param shoppingCartVo
     */
    @PostMapping("/p/shoppingcart/list")
    Result<List<ShoppingCartVo>> list(@RequestBody ShoppingCartVo shoppingCartVo);

    /**
     * 根据id批量删除购物车
     * @param ids
     */
    @PostMapping("/p/shoppingcart/delByIds")
    Result delByIds(@RequestBody List<String> ids);
}
