package com.biz.crm.mdm.shoppingcart.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.mdm.shoppingcart.ShoppingCartFeign;
import com.biz.crm.nebular.mdm.shoppingcart.ShoppingCartVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;

/**
 * @author heyijiang
 * @date 2020/10/20 16:37
 */
@Slf4j
@Component
public class ShoppingCartFeignImpl extends BaseAbstract implements FallbackFactory<ShoppingCartFeign> {
    @Override
    public ShoppingCartFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new ShoppingCartFeign() {

            @Override
            public Result<List<ShoppingCartVo>> list(ShoppingCartVo shoppingCartVo) {
                return doBack();
            }

            @Override
            public Result delByIds(List<String> ids) {
                return doBack();
            }
        };
    }
}
