package com.biz.crm.mdm.tableconfig.impl;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.mdm.tableconfig.MdmFunctionSubFeign;
import com.biz.crm.nebular.mdm.function.MdmFunctionReqVo;
import com.biz.crm.nebular.mdm.function.MdmFunctionRespVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubReqVo;
import com.biz.crm.nebular.mdm.pageconfig.MdmFunctionSubRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionReqVo;
import com.biz.crm.nebular.mdm.region.MdmRegionRespVo;
import com.biz.crm.nebular.mdm.region.MdmRegionSelectRespVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.ArrayList;
import java.util.List;

/**
 * feign接口熔断类
 *
 * @author zxw
 * @date 2020-11-20 14:59:37
 */
@Slf4j
@Component
public class MdmFunctionSubFeignImpl extends BaseAbstract implements FallbackFactory<MdmFunctionSubFeign> {

    @Override
    public MdmFunctionSubFeign create(Throwable throwable) {
        log.error("进入熔断",throwable);
        return new MdmFunctionSubFeign() {

            @Override
            public Result<PageResult<MdmFunctionRespVo>> page(MdmFunctionReqVo mdmFunctionReqVo) {
                return doBack();
            }

            @Override
            public Result<MdmFunctionSubRespVo> query(MdmFunctionSubReqVo mdmFunctionSubReqVo) {
                return doBack();
            }

            @Override
            public Result<List<MdmFunctionSubRespVo>> findSubList(MdmFunctionSubReqVo mdmFunctionSubReqVo) {
                return doBack();
            }

            @Override
            public Result<MdmFunctionSubRespVo> functionSubSearch(MdmFunctionSubReqVo mdmFunctionSubReqVo) {
                return doBack();
            }

        };
    }
}
