package com.biz.crm.mdm.terminal;

import com.biz.crm.mdm.terminal.impl.MdmTerminalSupplyFeignImpl;
import com.biz.crm.nebular.mdm.customer.MdmCustomerRespVo;
import com.biz.crm.nebular.mdm.terminal.MdmTerminalSupplyVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 终端供货关系feign接口
 *
 * @author Liao.Hua
 * @date 2020-09-01 14:13:56
 */
@FeignClient(url ="${feign.urlip:}",qualifier = "MdmTerminalSupplyFeign",name="crm-mdm",path = "mdm",fallbackFactory = MdmTerminalSupplyFeignImpl.class)
public interface MdmTerminalSupplyFeign {

    /**
     * 通过终端门店编码查询挂靠的客户信息
     */
    @ApiOperation(value = "通过终端门店编码查询挂靠的客户信息")
    @PostMapping("/mdmTerminalSupplyController/findBySupply")
    Result<List<MdmCustomerRespVo>> findBySupply(@RequestBody MdmTerminalSupplyVo mdmTerminalSupplyVo);

}
