package com.biz.crm.mdm.user;

import com.biz.crm.common.PageResult;
import com.biz.crm.config.CrmDictMethod;
import com.biz.crm.mdm.user.impl.MdmUserFeignImpl;
import com.biz.crm.nebular.mdm.user.req.MdmCustomerRelCustomerUserReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangeHeadReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserChangePasswordReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserPageReqVo;
import com.biz.crm.nebular.mdm.user.req.MdmUserReqVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserPageRespVo;
import com.biz.crm.nebular.mdm.user.resp.MdmUserRespVo;
import com.biz.crm.util.Result;
import io.swagger.annotations.ApiOperation;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;

import java.util.List;

/**
 * 用户信息表feign接口
 *
 * @author Tao.Chen
 * @date 2020-11-17 19:04:29
 */
@FeignClient(url = "${feign.urlip:}", qualifier = "MdmUserFeign", name = "crm-mdm", path = "mdm", fallbackFactory = MdmUserFeignImpl.class)
public interface MdmUserFeign {

    @ApiOperation(value = "查询分页列表")
    @PostMapping("/mdmUserController/pageList")
    Result<PageResult<MdmUserPageRespVo>> pageList(@RequestBody MdmUserPageReqVo reqVo);
    /**
     * 查询（传id或者userName）
     */
    @PostMapping("/mdmUserController/query")
    Result<MdmUserRespVo> query(@RequestBody MdmUserReqVo mdmUserReqVo);

    /**
     * 修改用户密码
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/mdmUserController/changePassword")
    Result changePassword(@RequestBody MdmUserChangePasswordReqVo reqVo);

    /**
     * 用户条件列表查询
     * @param mdmUserReqVo
     * @return
     */
    @PostMapping("/mdmUserController/list_detail")
    Result<List<MdmUserRespVo>> listDetail(@RequestBody MdmUserReqVo mdmUserReqVo);

    /**
     * 修改用户头像（userName必传）
     */
    @PostMapping("/mdmUserController/changeUserHeadUrl")
    Result changeUserHeadUrl(@RequestBody MdmUserChangeHeadReqVo reqVo);

    /**
     * 查询经销商关联的客户用户列表
     *
     * @param reqVo
     * @return
     */
    @PostMapping("/mdmCustomerUserController/findCustomerRelCustomerUserList")
    Result<List<MdmUserRespVo>> findCustomerRelCustomerUserList(@RequestBody MdmCustomerRelCustomerUserReqVo reqVo);
}
