package com.biz.crm.rebate;

import com.biz.crm.base.BaseAbstract;
import com.biz.crm.common.PageResult;
import com.biz.crm.nebular.dms.promotion.PromotionInfoRespVo;
import com.biz.crm.nebular.rebate.rebatepolicy.RebateVo;
import com.biz.crm.util.Result;
import feign.hystrix.FallbackFactory;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Component;

import java.util.List;


/**
 * 返利政策
 *  @author: luoqi
 *  @Date: 2020-10-19 18:15
 *  @version: V1.0
 *  @Description:
 */
@Slf4j
@Component
public class RebateFeignImpl extends BaseAbstract implements FallbackFactory<RebateFeign> {
    @Override
    public RebateFeign create(Throwable throwable) {
        log.error("返利政策RebateFeign进入熔断",throwable);
        return new RebateFeign() {

            @Override
            public Result<PageResult<RebateVo>> findRebatesByParam(RebateVo reqVo) {
                return doBack();
            }
        };
    }
}
